// CViewsBar class

#include <struct.h>
#include "CViewsBar.h"

CViewsBar::CViewsBar(CWnd* pOwner)
{
  Create( pOwner,
      IDD_DIALOGBAR,
      CBRS_NOALIGN, IDD_DIALOGBAR);
  SetWindowText("Views Presets");
  ((CButton*)GetDlgItem(IDC_VIEW0))->SetCheck(1);
}

CViewsBar::~CViewsBar()
{
  ReleaseList();
}


//----------------------------------------------
// implement tools
BOOL CViewsBar::OnAdd()
{
  long num = GetViewIndex();

  CComboBox* pCombo = (CComboBox*)GetDlgItem(IDC_PRESETS);
  if (!pCombo) return TRUE;

  z3dViewDescriptor* pDesc = new z3dViewDescriptor;
  if (!pDesc) return TRUE;

  CurrentState.CurrentParams.sysp(
    Z3D_REQUEST_GETVIEWDESCRIPTOR,
    NULL,
    NULL,
    (long*)pDesc,
    &num);

  char strPreset[MAX_OBJECT_NAMELENGTH];
  wsprintf(strPreset, pDesc->ViewTitle);
  if (IDOK != CurrentState.CurrentParams.sysp(
      Z3D_REQUEST_STRINGENTER,
      NULL,
      "Type Preset name (16 characters max)",
      (long*)&strPreset[0],
      NULL))
  {
    delete pDesc;
    return TRUE;
  }

  sprintf(pDesc->ViewTitle,
    "%.15s\0", strPreset);
  pCombo->AddString(pDesc->ViewTitle);

  pCombo->SetItemData(pCombo->GetCount()-1, (DWORD)pDesc);
  pCombo->SetCurSel(pCombo->GetCount()-1);
  
  return TRUE;
}

BOOL CViewsBar::OnSet()
{
  long num = GetViewIndex();

  CComboBox* pCombo = (CComboBox*)GetDlgItem(IDC_PRESETS);
  if (!pCombo) return TRUE;
  z3dViewDescriptor* pDesc = (z3dViewDescriptor*)pCombo->GetItemData(pCombo->GetCurSel());

  CurrentState.CurrentParams.sysp(
    Z3D_REQUEST_SETVIEWDESCRIPTOR,
    NULL,
    NULL,
    (long*)pDesc,
    &num);

  DWORD update = Z3D_PLUGRESULT_REDRAW;
  CurrentState.CurrentParams.sysp(
    Z3D_REQUEST_UPDATEMENT,
    NULL,
    NULL,
    (long*)&update,
    NULL);

  return TRUE;
}

BOOL CViewsBar::OnRemove()
{
  CComboBox* pCombo = (CComboBox*)GetDlgItem(IDC_PRESETS);
  if (!pCombo) return TRUE;
  z3dViewDescriptor* pDesc = (z3dViewDescriptor*)pCombo->GetItemData(pCombo->GetCurSel());
  if (pDesc) delete pDesc;
  pCombo->DeleteString(pCombo->GetCurSel());
  pCombo->SetWindowText("");
  pCombo->SetCurSel(0);
  return TRUE;
}

BOOL CViewsBar::OnCmdMsg( UINT nID, int nCode, void* pExtra, AFX_CMDHANDLERINFO* pHandlerInfo )
{
  if (nID == IDC_ADD)
    return OnAdd();
  if (nID == IDC_SET)
    return OnSet();
  if (nID == IDC_REMOVE)
    return OnRemove();

////////////////////////////////////////////////////////////////////////////////////
// process standart CWnd's OnCmdMsg. If not handled, process it through CRollUpBar'
  
  if (!CWnd::OnCmdMsg(nID, nCode, pExtra, pHandlerInfo))
    return CRollUpBar::OnCmdMsg(nID, nCode, pExtra, pHandlerInfo);
  else
    return TRUE;
}

int CViewsBar::GetViewIndex()
{
  if (((CButton*)GetDlgItem(IDC_VIEW0))->GetCheck()==1)
    return 1;
  if (((CButton*)GetDlgItem(IDC_VIEW1))->GetCheck()==1)
    return 2;
  if (((CButton*)GetDlgItem(IDC_VIEW2))->GetCheck()==1)
    return 3;
  if (((CButton*)GetDlgItem(IDC_VIEW3))->GetCheck()==1)
    return 4;
  return 0;
}

void CViewsBar::ReleaseList()
{
  CComboBox* pCombo = (CComboBox*)GetDlgItem(IDC_PRESETS);
  if (!pCombo) return;
  while (pCombo->GetCount() > 0)
  {
    z3dViewDescriptor* pDesc = (z3dViewDescriptor*)pCombo->GetItemData(0);
    if (pDesc) delete pDesc;
    pCombo->DeleteString(0);
  }
  pCombo->SetWindowText("");
  pCombo->SetCurSel(0);
}
